﻿#include "functions/copyObject.as"
save = function(saveIndex)
{
	// remember player's current grid position
	var oldGridPosition = {
		x:RAM.player.gridPosition.x,
		y:RAM.player.gridPosition.y
	}// oldGridPosition obj
	
	// update player's location in RAM
	var xMapOffset = Math.floor(PLAYER._x /320);
	var yMapOffset = Math.floor(PLAYER._y /240);
	var xNew = RAM.player.gridPosition.x +xMapOffset;
	var yNew = RAM.player.gridPosition.y +yMapOffset;
	RAM.player.gridPosition.x = xNew;
	RAM.player.gridPosition.y = yNew;
	RAM.player.pixelPosition = {
		x:PLAYER._x,
		y:PLAYER._y
	}
	RAM.player.vel = PLAYER.vel;
	RAM.player.direction = PLAYER.direction;
	RAM.player.enterFrom = null;
	// store current music
	RAM.audio.music.songName = MUSIC.songName;
	RAM.audio.music.isPlaying = MUSIC.isPlaying;
	// store save metadata
	//RAM.saveInfo.saveName = saveName;
	RAM.saveInfo.lastSaveIndex = saveIndex;
	RAM.saveInfo.playTime  +=  getTimer() -Number(RAM.saveInfo.loadTime);
	RAM.saveInfo.loadTime  =  getTimer();
	
	// save RAM
	if(ROM.misc.gameId)
	{// if:  gameId is specified
		// // access saved data
		var srm = SharedObject.getLocal(ROM.misc.gameId);
		// // init data if necessary
		if(!srm.data.slot)
			srm.data.slot = [];
		// // select & erase save slot
		var thisSlot = srm.data.slot[saveIndex] = {};
		//srm.clear();
		// // store data
		copyObject(RAM, thisSlot);
		// // write data to disk now
		var success = srm.flush();
		
		// restore current grid position
		RAM.player.gridPosition.x = oldGridPosition.x;
		RAM.player.gridPosition.y = oldGridPosition.y;
	}// if:  gameId is specified
	else{
		var success = false;
	}
	
	if(success){
		trace("Save Successful");
		return true;
	}else{
		trace("Save Failed");
		return false;
	}
}// save()